<?php
include("auth.php");
require "conn.php";

// ✅ Fetch partner record
if (isset($_GET['id'])) {
  $id = intval($_GET['id']);
  $sql = "SELECT * FROM tbl_vendor WHERE id=$id";
  $result = mysqli_query($conn, $sql);
  $row = mysqli_fetch_assoc($result);
}

// ✅ Handle form submit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
  $id = intval($_POST['id']);
  $name = mysqli_real_escape_string($conn, $_POST['name']);
  $role = mysqli_real_escape_string($conn, $_POST['role']);
  $designation = mysqli_real_escape_string($conn, $_POST['designation']);
  $email = mysqli_real_escape_string($conn, $_POST['email']);
  $mobile = mysqli_real_escape_string($conn, $_POST['mobile']);
  $status = mysqli_real_escape_string($conn, $_POST['status']);
  $address = mysqli_real_escape_string($conn, $_POST['address']);
  $dob = mysqli_real_escape_string($conn, $_POST['dob']);
  $pan = mysqli_real_escape_string($conn, $_POST['pan']);
  $acc_no = mysqli_real_escape_string($conn, $_POST['acc_no']);
  $bank_name = mysqli_real_escape_string($conn, $_POST['bank_name']);
  $branch = mysqli_real_escape_string($conn, $_POST['branch']);
  $ifsc = mysqli_real_escape_string($conn, $_POST['ifsc']);
  $acc_holder = mysqli_real_escape_string($conn, $_POST['acc_holder']);

  $sql = "UPDATE tbl_vendor SET 
              name='$name',
              role='$role',
              designation='$designation',
              email='$email',
              mobile='$mobile',
              status='$status',
              address='$address',
              dob='$dob',
              pan='$pan',
              acc_no='$acc_no',
              bank_name='$bank_name',
              branch='$branch',
              ifsc='$ifsc',
              acc_holder='$acc_holder',
              updated_at=NOW()
          WHERE id=$id";

  if (mysqli_query($conn, $sql)) {
    header("Location:users-list.php?msg=updated");
    exit();
  } else {
    echo "Error updating record: " . mysqli_error($conn);
  }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Edit Partner</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <?php include("templates/inc.php"); ?>
</head>

<body>
  <!-- ======= Header ======= -->
  <?php include("templates/header.php"); ?>
  <!-- End Header -->

  <!-- ======= Sidebar ======= -->
  <?php include("templates/sidebar.php"); ?>
  <!-- End Sidebar -->

  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Edit Partner</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
          <li class="breadcrumb-item"><a href="partner_accounts_list.php">Partner Accounts</a></li>
          <li class="breadcrumb-item active">Edit Partner</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
            <div class="card-body">
              <h5 class="card-title">Edit Partner Information</h5>

              <!-- Edit Form -->
              <form method="POST">
                <input type="hidden" name="id" value="<?php echo $row['id']; ?>">

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Name</label>
                  <div class="col-sm-10">
                    <input type="text" name="name" class="form-control" value="<?php echo $row['name']; ?>" required>
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Role</label>
                  <div class="col-sm-10">
                    <select name="role" class="form-select">
                      <option value="Partner" <?php if($row['role']=="Partner") echo "selected"; ?>>Partner</option>
                      <option value="Dealer" <?php if($row['role']=="Dealer") echo "selected"; ?>>Dealer</option>
                    </select>
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Designation</label>
                  <div class="col-sm-10">
                    <input type="text" name="designation" class="form-control" value="<?php echo $row['designation']; ?>">
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Email</label>
                  <div class="col-sm-10">
                    <input type="email" name="email" class="form-control" value="<?php echo $row['email']; ?>" required>
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Mobile</label>
                  <div class="col-sm-10">
                    <input type="text" name="mobile" class="form-control" value="<?php echo $row['mobile']; ?>" required>
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Address</label>
                  <div class="col-sm-10">
                    <input type="text" name="address" class="form-control" value="<?php echo $row['address']; ?>">
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Date of Birth</label>
                  <div class="col-sm-10">
                    <input type="text" name="dob" class="form-control" value="<?php echo $row['dob']; ?>">
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">PAN</label>
                  <div class="col-sm-10">
                    <input type="text" name="pan" class="form-control" value="<?php echo $row['pan']; ?>">
                  </div>
                </div>

                <hr>
                <h5 class="card-title">Bank Details</h5>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Account No</label>
                  <div class="col-sm-10">
                    <input type="text" name="acc_no" class="form-control" value="<?php echo $row['acc_no']; ?>">
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Bank Name</label>
                  <div class="col-sm-10">
                    <input type="text" name="bank_name" class="form-control" value="<?php echo $row['bank_name']; ?>">
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Branch</label>
                  <div class="col-sm-10">
                    <input type="text" name="branch" class="form-control" value="<?php echo $row['branch']; ?>">
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">IFSC</label>
                  <div class="col-sm-10">
                    <input type="text" name="ifsc" class="form-control" value="<?php echo $row['ifsc']; ?>">
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Account Holder</label>
                  <div class="col-sm-10">
                    <input type="text" name="acc_holder" class="form-control" value="<?php echo $row['acc_holder']; ?>">
                  </div>
                </div>

                <div class="row mb-3">
                  <label class="col-sm-2 col-form-label">Status</label>
                  <div class="col-sm-10">
                    <select name="status" class="form-select">
                      <option value="Active" <?php if($row['status']=="Active") echo "selected"; ?>>Active</option>
                      <option value="Inactive" <?php if($row['status']=="Inactive") echo "selected"; ?>>Inactive</option>
                    </select>
                  </div>
                </div>

                <div class="row mb-3">
                  <div class="col-sm-10 offset-sm-2">
                    <button type="submit" class="btn btn-success">Update</button>
                    <a href="partner_accounts_list.php" class="btn btn-secondary">Cancel</a>
                  </div>
                </div>
              </form><!-- End form -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->

  <!-- ======= Footer ======= -->
  <?php include("templates/footer.php"); ?>
  <!-- End Footer -->

  <?php include("templates/vendors.php"); ?>

</body>
</html>
