<?php
include("auth.php");
session_start();


?>


<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Withdrawal</title>
  <meta content="" name="description">
  <meta content="" name="keywords">
  <link href="assets/img/favicon.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">
  <?php include("templates/inc.php"); ?>

  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
  <script>
    $(document).ready(function() {

      $("#btnWithdraw").click(function() {

        var amount = $("#txtAmount").val();
        var bank = $("#txtBank").val();
        var accountholname = $("#txtAccount_holdername").val();
        var accountnumber = $("#txtAccount_Number").val();
        var ifsc = $("#txtIfsc").val();


        $.ajax({
          type: 'post',
          url: 'withdraw-bank-action.php',
          data: {
            'amount': amount,
            'bank': bank,
            'accountholname': accountholname,
            'accountnumber': accountnumber,
            'ifsc': ifsc,
            'action': 'withdraw-bank'
          },
          success: function(data) {
            alert(data);
            location.reload();

          }
        });



      });


    });
  </script>
</head>

<body>

  <!-- ======= Header ======= -->
  <?php
  include("templates/header.php");
  ?>

  <!-- End Header -->

  <!-- ======= Sidebar ======= -->

  <?php
  include("templates/sidebar.php");

  ?>


  <!-- End Sidebar-->

  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Payments</h1>

    </div><!-- End Page Title -->




    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card" style="overflow:scroll;">
            <div class="card-body" id="records">
              <h5 class="card-title">Payment List</h5>
              <!-- Action buttons -->
              <button onclick="printTable()" class="btn btn-primary btn-sm mb-3">🖨 Print</button>
              <button onclick="exportExcel()" class="btn btn-success btn-sm mb-3">📥 Download Excel</button>


        
                <table id="example" class="table table-striped dt-responsive nowrap" style="width:100%">
  <thead>
    <tr>
      <th>SL NO</th>
      <th>Date</th>
      <th>ID</th> <!-- v_code -->
      <th>Name</th>
      <th>Type</th> <!-- degination -->
      <th>Amount</th>
      <th>TDS</th>
      <th>Net Amt</th>
      <th>Description</th>
      <th>Status</th>
    </tr>
  </thead>
  <tbody>
    <?php
    require "./conn.php";
    $sl = 1;

    if (!isset($_SESSION['user_id'])) {
      die("Unauthorized access.");
    }

    $vendor_id = intval($_SESSION['user_id']); // current logged-in vendor id

    // JOIN vendor info
    $sql = "SELECT p.*, v.v_code, v.designation, v.name 
            FROM payment p
            INNER JOIN tbl_vendor v ON p.vendor_id = v.id
            ORDER BY p.payment_date DESC";

    $rs = mysqli_query($conn, $sql);

    while ($row = mysqli_fetch_assoc($rs)) {
      echo "<tr>";
      echo "<td>" . $sl . "</td>";
      echo "<td>" . $row['payment_date'] . "</td>";
      echo "<td>" . $row['v_code'] . "</td>";             // vendor code
      echo "<td>" . $row['name'] . "</td>";               // vendor name
      echo "<td>" . $row['designation'] . "</td>";         // vendor type / designation
      echo "<td>" . number_format($row['amount'], 2) . "</td>";   // Gross
      echo "<td>" . number_format($row['tds'], 2) . "</td>";      // TDS
      echo "<td>" . number_format($row['netamt'], 2) . "</td>";   // Net credited
      echo "<td>" . ($row['description'] ?? '-') . "</td>";
      $status = $row['status'];
        $color = "";
        
        

        if ($status === "pending") {
            $color = "background-color: yellow; color:black; padding:5px 10px; border-radius:5px;";
        } elseif ($status === "paid") {
            $color = "background-color: green; color:white; padding:5px 10px; border-radius:5px;";
        }
        
        echo "<td><span style='{$color}'>" . htmlspecialchars($status) . "</span></td>";
        echo "</tr>";

      $sl++;
    }
    ?>
  </tbody>
</table>

            </div>
          </div>
        </div>
      </div>
    </section>












    <br><br><br>




  </main><!-- End #main -->
  <!-- ======= Footer ======= -->
  <?php
  include("templates/footer.php");
  ?>

  <!-- End Footer -->


  <?php include("templates/vendors.php"); ?>

  <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
  <script src="https://cdn.datatables.net/responsive/2.4.1/js/dataTables.responsive.min.js"></script>
  <!-- SheetJS CDN -->
  <script src="https://cdn.jsdelivr.net/npm/xlsx/dist/xlsx.full.min.js"></script>

  <script>
    // ✅ Print table
    function printTable() {
      var divToPrint = document.getElementById("example");
      var newWin = window.open("");
      newWin.document.write("<html><head><title>Print</title></head><body>");
      newWin.document.write(divToPrint.outerHTML);
      newWin.document.write("</body></html>");
      newWin.print();
      newWin.close();
    }

    // ✅ Export to Excel
    function exportExcel() {
      var table = document.getElementById("example");
      var wb = XLSX.utils.table_to_book(table, {
        sheet: "Payments"
      });
      XLSX.writeFile(wb, "payment_list.xlsx");
    }
  </script>
  <script>
    $(document).ready(function() {
      $('#example').DataTable();
    });
  </script>


</html>