<?php include("auth.php");
session_start();
require("conn.php");
$action = "Add";
$id = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'], $_POST['status'])) {
    $id = (int)$_POST['id'];
    $status = $_POST['status'];

    $sql = "UPDATE tbl_wallet_withdraw SET status=? WHERE id=?";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }
    $stmt->bind_param("si", $status, $id);

    if ($stmt->execute()) {
        // 🔁 Reload SAME page (keeps any query string too)
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit;
    } else {
        die("Error updating status: " . $stmt->error);
    }
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>Reward </title>
    <meta content="" name="description">
    <meta content="" name="keywords">
    <link href="assets/img/favicon.png" rel="icon">
    <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">
    <?php include("templates/inc.php"); ?>

    <script src="scripts/ManagePin.js" type="text/javascript" language="javascript"></script>


</head>

<body>

    <!-- ======= Header ======= -->
    <?php
    include("templates/header.php");
    ?>

    <!-- End Header -->

    <!-- ======= Sidebar ======= -->
    <?php
    include("templates/sidebar.php");

    ?>
    <!-- End Sidebar-->

    <main id="main" class="main">

        <div class="pagetitle">
            <h1>Withdrowal List</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item">Reward</li>

                </ol>
            </nav>
            <hr>
            
        </div><!-- End Page Title -->



      <section class="section">
        <div class="row">
          <div class="col-lg-12">

            <div class="card" style="overflow:scroll;">
              <div class="card-body" id="records">
              <h5 class="card-title">Withdrowal List</h5>
                            <!-- Action buttons -->
              <button onclick="printTable()" class="btn btn-primary btn-sm mb-3">🖨 Print</button>
              <button onclick="exportExcel()" class="btn btn-success btn-sm mb-3">📥 Download Excel</button>

                <table id="example" class="table datatable">
                  <thead>
                                        <tr>
										    <th>SL NO</th>
											<th>UID</th>
											<th>DATE</th>
											 <th>AMOUNT</th>
											  <th>BANK</th>	
												<th>ACC.HO</th>
												<th>ACC.NO</th>
												 <th>IFSC</th>
												  <th>STATUS</th>
												
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    <?php
									require "./conn.php";
									 $sl=1;

									$cid=$_SESSION['v_code'];
									$sql="select * from   tbl_wallet_withdraw order by trans_date desc";
									  $rs=mysqli_query($conn,$sql);
									  while($row=mysqli_fetch_assoc($rs))
									  { echo '<tr>'; 
											echo'<td>'.$sl.'</td>';
											echo'<td>'.$row['cid'].'</td>';
										  echo'<td>'.$row['trans_date'].'</td>';
											echo'<td>'.$row['amount'].'</td>';
										
											echo'<td>'.$row['bank_name'].'</td>';
											echo'<td>'.$row['account_holder_name'].'</td>';
											echo'<td>'.$row['account_no'].'</td>';
											echo'<td>'.$row['ifsc_code'].'</td>';
										
											$status = $row['status'];
                      $color = "";
                      if ($status === "Under Process") {
                          $color = "background-color: yellow; color:black;";
                      } elseif ($status === "Transfered") {
                          $color = "background-color: green; color:white;";
                      } 

                      echo "<td>
                              <form method='post' action='' style='margin:0;'>
                                <input type='hidden' name='id' value='".htmlspecialchars($row['id'])."'>
                                <select name='status' class='status-select' style='{$color}' onchange='this.form.submit()'>
                                  <option value='Under Process' ".($status==="Under Process"?"selected":"").">Under Process</option>
                                  <option value='Transfered' ".($status==="Transfered"?"selected":"").">Transfered</option>
                                  
                                </select>
                              </form>
                            </td>";
                      echo"</tr>";
										$sl++;
									  }
									  ?>
                                        </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        
      </section>









    </main><!-- End #main -->
    
             <!-- SheetJS CDN -->
  <script src="https://cdn.jsdelivr.net/npm/xlsx/dist/xlsx.full.min.js"></script>

  <script>
    // ✅ Print table
    function printTable() {
      var divToPrint = document.getElementById("example");
      var newWin = window.open("");
      newWin.document.write("<html><head><title>Print</title></head><body>");
      newWin.document.write(divToPrint.outerHTML);
      newWin.document.write("</body></html>");
      newWin.print();
      newWin.close();
    }

    // ✅ Export to Excel
    function exportExcel() {
      var table = document.getElementById("example");
      var wb = XLSX.utils.table_to_book(table, {
        sheet: "Payments"
      });
      XLSX.writeFile(wb, "payment_list.xlsx");
    }
  </script>

    <!-- ======= Footer ======= -->
    <?php
    include("templates/footer.php");
    ?>
    <!-- End Footer -->



    <?php include("templates/vendors.php"); ?>


</body>

</html>