<?php include("auth.php");
session_start();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>Customer List</title>
    <meta content="" name="description">
    <meta content="" name="keywords">
    <link href="assets/img/favicon.png" rel="icon">
    <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">
    <?php include("templates/inc.php"); ?>
    <script src="scripts/selesman.js" type="text/javascript" language="javascript"></script>


</head>

<body>

    <!-- ======= Header ======= -->
    <?php
    include("templates/header.php");
    ?>

    <!-- End Header -->

    <!-- ======= Sidebar ======= -->
    <?php
    include("templates/sidebar.php");

    ?>
    <!-- End Sidebar-->

    <main id="main" class="main">

        <div class="pagetitle">
            <h1>Customer List</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item">Customer List</li>
                </ol>
            </nav>
            <hr>
        </div><!-- End Page Title -->

        <section class="section">
            <a href="customer.php">
                <button type="button" class="btn btn-info"><i class="bi bi-plus me-1"></i> Add New</button>
            </a><br><br>

            <section class="section">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card" style="overflow:scroll;">
                            <div class="card-body" id="records">
                                <h5 class="card-title">Customer List</h5>
                                <!-- Table with stripped rows -->
                                <table class="table datatable">
                                    <thead>
                                        <tr>
                                            <th scope="col">Sl</th>
                                            <th scope="col">Photo</th>
                                            <th scope="col">Dealer ID</th>
                                            <th scope="col">Customer ID</th>
                                            <th scope="col">Services</th>
                                            <th scope="col">Name</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Mobile</th>

                                            <th scope="col">Wts No</th>
                                            <th scope="col">Web</th>
                                            <th scope="col">State</th>
                                            <th scope="col">Dist</th>
                                            
                                            <th scope="col">Add</th>
                                            <th scope="col">Requir</th>


                                            <th scope="col">Status</th>

                                            <th scope="col" colspan="2">Action</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php
                                        require "conn.php";
                                        $v_code = $_SESSION['v_code'];
                                        $sl = 1;
                                        $sql = "select * from tbl_customer where v_code='$v_code' and deleted_at is NULL order by id desc";

                                        $rs = mysqli_query($conn, $sql);
                                        while ($row = mysqli_fetch_assoc($rs)) {
                                            echo "<tr>";
                                            echo '<td>' . $sl . '</td>';
                                            
                                            
                                            echo '<td><img src="' . $row['file_url'] . '" height="50" width="50" class="img-thumbnail" /></td>';
                                            echo '<td><span class="badge bg-danger btn-lg"><i class="bi bi-star me-1"></i> ' . $row['v_code'] . '</span></td>';
                                            echo '<td><span class="badge bg-info btn-lg"><i class="bi bi-star me-1"></i> ' . $row['s_code'] . '</span></td>';
                                            echo '<td>' . $row['services'] . '</td>';
                                            echo '<td><span class="badge bg-success"> ' . $row['name'] . '</span></td>';
                                            echo '<td>' . $row['email'] . '</td>';
                                            echo '<td><span class="badge bg-info"><i class="bi bi-telephone-fill"></i> ' . $row['mobile'] . '</span></td>';
                                            echo '<td><span class="badge bg-info"><i class="bi bi-whatsapp"></i> ' . $row['whatsapp'] . '</span></td>';
                                            echo '<td>' . $row['web_url'] . '</td>';
                                            echo '<td>' . $row['state_id'] . '</td>';
                                            echo '<td>' . $row['district_id'] . '</td>';
                                            echo '<td>' . $row['address'] . '</td>';
                                            echo '<td>' . $row['req'] . '</td>';

                                            if ($row['status'] == Active) {

                                                echo '<td><span class="badge bg-success btn-lg"> ' . $row['status'] . '</span></td>';
                                            } else {

                                                echo '<td><span class="badge bg-danger btn-lg"> ' . $row['status'] . '</span></td>';
                                            }

                                            echo '<td><a href="customer.php?action=' . base64_encode("Edit") . '&id=' . base64_encode($row['id']) . '" class="btn btn-primary"><i class="bi bi-pencil"></i></a>
                      <button id=' . $row['id'] . ' class="btn btn-danger delete"><i class="bi bi-trash"></i></button></td>';

                                            echo "</tr>";
                                            $sl++;
                                        }
                                        ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </section>

    </main><!-- End #main -->

    <!-- ======= Footer ======= -->
    <?php
    include("templates/footer.php");
    ?>
    <!-- End Footer -->


    <?php include("templates/vendors.php"); ?>

</body>

</html>