<?php include("auth.php");
session_start();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>Leads List</title>
    <meta content="" name="description">
    <meta content="" name="keywords">
    <link href="assets/img/favicon.png" rel="icon">
    <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">
    <?php include("templates/inc.php"); ?>
    <script src="scripts/Leads.js" type="text/javascript" language="javascript"></script>


</head>

<body>

    <!-- ======= Header ======= -->
    <?php
    include("templates/header.php");
    ?>

    <!-- End Header -->

    <!-- ======= Sidebar ======= -->
    <?php
    include("templates/sidebar.php");

    ?>
    <!-- End Sidebar-->

    <main id="main" class="main">

        <div class="pagetitle">
            <h1>Leads List</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item">Leads List</li>
                </ol>
            </nav>
            <hr>
        </div><!-- End Page Title -->

        <section class="section">
            <a href="leads.php">
                <button type="button" class="btn btn-info"><i class="bi bi-plus me-1"></i> Add New</button>
            </a><br><br>

            <section class="section">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card" style="overflow:scroll;">
                            <div class="card-body" id="records">
                                <h5 class="card-title">Leads List</h5>
                                <!-- Table with stripped rows -->
                                <table class="table datatable">
                                    <thead>
                                        <tr>
                                            <th scope="col">Sl</th>
                                           
                                            <th scope="col">Name</th>
                                             <th scope="col">Mobile</th>
                                             <th scope="col">Wts No</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Ref</th>
                                            <th scope="col">Assign</th>
                                            <th scope="col">Categ</th>
                                            <th scope="col">State</th>
                                            <th scope="col">City</th>
                                             <th scope="col">Web</th>

                                            <th scope="col">Status</th>

                                            <th scope="col" colspan="2">Action</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php
                                        require "conn.php";
         
                                        $sl = 1;
                                        $sql = "select * from tbl_leads where deleted_at is NULL order by id desc";

                                        $rs = mysqli_query($conn, $sql);
                                        while ($row = mysqli_fetch_assoc($rs)) {
                                            echo "<tr>";
                                            echo '<td>' . $sl . '</td>';
                                            
                                            echo '<td><span class="badge bg-success"> ' . $row['name'] . '</span></td>';
                                            echo '<td><span class="badge bg-info"><i class="bi bi-telephone-fill"></i> ' . $row['mobile'] . '</span></td>';
                                            echo '<td><span class="badge bg-info"><i class="bi bi-whatsapp"></i> ' . $row['whatsapp'] . '</span></td>';
                                            echo '<td>' . $row['email'] . '</td>';
                                            echo '<td>' . $row['referred_by'] . '</td>';
                                            echo '<td>' . $row['assign_to'] . '</td>';
                                            echo '<td>' . $row['category'] . '</td>';
                                            echo '<td>' . $row['state'] . '</td>';
                                            echo '<td>' . $row['city'] . '</td>';
                                            echo '<td>' . $row['website'] . '</td>';

                                            if ($row['status'] == Active) {

                                                echo '<td><span class="badge bg-success btn-lg"> ' . $row['status'] . '</span></td>';
                                            } else {

                                                echo '<td><span class="badge bg-danger btn-lg"> ' . $row['status'] . '</span></td>';
                                            }

                                            echo '<td><a href="leads.php?action=' . base64_encode("Edit") . '&id=' . base64_encode($row['id']) . '" class="btn btn-primary"><i class="bi bi-pencil"></i></a>
                      <button id=' . $row['id'] . ' class="btn btn-danger delete"><i class="bi bi-trash"></i></button></td>';

                                            echo "</tr>";
                                            $sl++;
                                        }
                                        ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </section>

    </main><!-- End #main -->

    <!-- ======= Footer ======= -->
    <?php
    include("templates/footer.php");
    ?>
    <!-- End Footer -->


    <?php include("templates/vendors.php"); ?>

</body>

</html>