<?php include("auth.php") ?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Post List</title>
  <meta content="" name="description">
  <meta content="" name="keywords">
  <link href="assets/img/favicon.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">
  <?php include("templates/inc.php"); ?>
  <script src="scripts/post.js" type="text/javascript" language="javascript"></script>


</head>

<body>

  <!-- ======= Header ======= -->
  <?php
  include("templates/header.php");
  ?>

  <!-- End Header -->

  <!-- ======= Sidebar ======= -->
  <?php
  include("templates/sidebar.php");

  ?>
  <!-- End Sidebar-->

  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Post</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
          <li class="breadcrumb-item">Post List</li>
        </ol>
      </nav>
      <hr>
    </div><!-- End Page Title -->

    <section class="section">
      <a href="post.php">
        <button type="button" class="btn btn-primary"><i class="bi bi-plus me-1"></i> Add New</button>
      </a><br><br>

      <section class="section">
        <div class="row">
          <div class="col-lg-12">

            <div class="card" style="overflow:scroll;">
              <div class="card-body" id="records">
                <h5 class="card-title">Post List</h5>
                <!-- Table with stripped rows -->
                <table class="table datatable">
                  <thead>
                    <tr>
                      <th scope="col">Sl</th>
                      <th scope="col">Vendor Code</th>
                      <th scope="col">state</th>
                      <th scope="col">District</th>
                      <th scope="col">Area</th>
                      <th scope="col">Category</th>
                      <th scope="col">Photo</th>
                      <th scope="col">Title</th>
                      <th scope="col">Desc.</th>
                      <th scope="col">C.Date</th>
                      <th scope="col">E.Date</th>
                      <th scope="col" colspan="2">Action</th>
                    </tr>
                  </thead>

                  <tbody>
                    <?php
                    require "conn.php";
                    $v_code = $_SESSION['v_code'];
                    $sl = 1;
                    $sql = "select * from tbl_post where v_code='$v_code' and deleted_at is NULL order by id desc";

                    $rs = mysqli_query($conn, $sql);
                    while ($row = mysqli_fetch_assoc($rs)) {
                      echo "<tr>";
                      echo '<td>' . $sl . '</td>';

                      echo '<td><span class="badge bg-warning btn-lg"><i class="bi bi-star me-1"></i> ' . $row['v_code'] . '</span></td>';


                      echo '<td><span class="badge bg-success"><i class="bi bi-globe"></i> ' . $row['state'] . '</span></td>';
                      echo '<td><span class="badge bg-secondary"><i class="bi bi-geo-alt-fill"></i> ' . $row['district'] . '</span></td>';
                      echo '<td><span class="badge bg-info"><i class="bi bi-geo-alt-fill"></i> ' . $row['area'] . '</span></td>';
                      echo '<td>' . $row['category'] . '</td>';
                      echo '<td><img src="' . $row['event_url'] . '" height="70" width="90" class="img-thumbnail" /></td>';
                      echo '<td>' . $row['des'] . '</td>';
                      echo '<td>' . $row['title'] . '</td>';
                      echo '<td>' . $row['created_at'] . '</td>';


                      if ($row['created_at'] == $row['e_date']) {
                        echo '<td>  <span class="badge bg-danger"><i class="bi bi-x-circle me-2"></i>' . $row['e_date'] . '</span></td>';

                      } else {

                        echo '<td> 
                         <span class="badge bg-success"><i class="bi bi-x-circle me-2"></i>' . $row['e_date'] . '</span>                        
                         </td>';

                      }



                      echo '<td><a href="post.php?action=' . base64_encode("Edit") . '&id=' . base64_encode($row['id']) . '" class="btn btn-primary"><i class="bi bi-pencil"></i></a>
                      <button id=' . $row['id'] . ' class="btn btn-danger delete"><i class="bi bi-trash"></i></button></td>';

                      echo "</tr>";
                      $sl++;
                    }
                    ?>

                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

      </section>

  </main><!-- End #main -->

  <!-- ======= Footer ======= -->
  <?php
  include("templates/footer.php");
  ?>
  <!-- End Footer -->


  <?php include("templates/vendors.php"); ?>

</body>

</html>